/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.particle;

import net.minecraft.class_3532;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class Transform {
    private Vector2f position;
    private float roll;
    private Vector2f size;
    private Vector2f oldPosition;
    private float oldRoll;
    private Vector2f oldSize;

    public Transform(Vector2f position, float roll, Vector2f size) {
        this.position = position;
        this.roll = roll;
        this.size = size;
        this.oldPosition = new Vector2f((Vector2fc)position);
        this.oldRoll = roll;
        this.oldSize = new Vector2f((Vector2fc)size);
    }

    public void setRoll(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        this.roll = angle;
    }

    public void updateOldValues() {
        this.oldPosition = new Vector2f((Vector2fc)this.position);
        this.oldRoll = this.roll;
        this.oldSize = new Vector2f((Vector2fc)this.size);
    }

    public Vector2f getInterpolatedPosition(float partialTicks) {
        return new Vector2f(class_3532.method_16439((float)partialTicks, (float)this.oldPosition.x, (float)this.position.x), class_3532.method_16439((float)partialTicks, (float)this.oldPosition.y, (float)this.position.y));
    }

    public float getInterpolatedRoll(float partialTicks) {
        return Transform.lerpAngle(partialTicks, this.oldRoll, this.roll);
    }

    public Vector2f getInterpolatedSize(float partialTicks) {
        return new Vector2f(class_3532.method_16439((float)partialTicks, (float)this.oldSize.x, (float)this.size.x), class_3532.method_16439((float)partialTicks, (float)this.oldSize.y, (float)this.size.y));
    }

    private static float lerpAngle(float partialTicks, float start, float end) {
        float delta = (end - start + 540.0f) % 360.0f - 180.0f;
        return (start + delta * partialTicks + 360.0f) % 360.0f;
    }

    public Vector2f getPosition() {
        return this.position;
    }

    public float getRoll() {
        return this.roll;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public Vector2f getOldPosition() {
        return this.oldPosition;
    }

    public float getOldRoll() {
        return this.oldRoll;
    }

    public Vector2f getOldSize() {
        return this.oldSize;
    }

    public void setPosition(Vector2f position) {
        this.position = position;
    }

    public void setSize(Vector2f size) {
        this.size = size;
    }
}

